/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8239;

import ibm.nways.jdm.common.OctetString;
import ibm.nways.ras.RAS;

public class STDecoder {
    private static final int RASID = 4;
    private static final int RASSUBID = 19;
    private byte[] entry = null;
    private int version;
    public static int V1 = 1;
    public static int V2 = 2;
    public static int baseOffset;
    public static int HUBID;
    public static int HUBTYPE;
    public static int EXPTYPE;
    public static int RIROTYPE;
    public static int RINGSPEED;
    public static int LOADSTATUS;
    public static int FANSTATUS;
    public static int DATAINSTATUS;
    public static int DATAOUTSTATUS;
    public static int RINGINSTATUS;
    public static int RINGOUTSTATUS;
    public static int CONTROLINSTATUS;
    public static int CONTROLOUTSTATUS;
    private static int HUBMAX;
    private static int HIBYTE;
    private static int HIBIT;
    private static int HIMASK;
    private static int HTBYTE;
    private static int HTBIT;
    private static int HTMASK;
    private static int ETBYTE;
    private static int ETBIT;
    private static int ETMASK;
    private static int RTBYTE;
    private static int RTBIT;
    private static int RTMASK;
    private static int RSBYTE;
    private static int RSBIT;
    private static int RSMASK;
    private static int LSBYTE;
    private static int LSBIT;
    private static int LSMASK;
    private static int FSBYTE;
    private static int FSBIT;
    private static int FSMASK;
    private static int DISBYTEv1;
    private static int DISBITv1;
    private static int DISMASKv1;
    private static int DISBYTEv2;
    private static int DISBITv2;
    private static int DISMASKv2;
    private static int DOSBYTEv1;
    private static int DOSBITv1;
    private static int DOSMASKv1;
    private static int DOSBYTEv2;
    private static int DOSBITv2;
    private static int DOSMASKv2;
    private static int RISBYTEv1;
    private static int RISBITv1;
    private static int RISMASKv1;
    private static int RISBYTEv2;
    private static int RISBITv2;
    private static int RISMASKv2;
    private static int ROSBYTEv1;
    private static int ROSBITv1;
    private static int ROSMASKv1;
    private static int ROSBYTEv2;
    private static int ROSBITv2;
    private static int ROSMASKv2;
    private static int CISBYTEv1;
    private static int CISBITv1;
    private static int CISMASKv1;
    private static int CISBYTEv2;
    private static int CISBITv2;
    private static int CISMASKv2;
    private static int COSBYTEv1;
    private static int COSBITv1;
    private static int COSMASKv1;
    private static int COSBYTEv2;
    private static int COSBITv2;
    private static int COSMASKv2;
    private static int HUBBYTEVALUE;
    private static int HUBBITVALUE;
    private static int HUBMASKVALUE;
    private static int[][] hubInfoMapv1;
    private static int[][] hubInfoMapv2;
    public static int PORTSTATUS;
    public static int PORTMODE;
    public static int PORTALERT;
    public static int PORTSECURITY;
    public static int PORTSPEED;
    private static int PORTMAX;
    private static int BASEPORTOFFSETv1;
    private static int BASEPORTOFFSETv2;
    private static int PSTBIT;
    private static int PSTMASK;
    private static int PMDBIT;
    private static int PMDMASK;
    private static int PATBIT;
    private static int PATMASK;
    private static int PSEBIT;
    private static int PSEMASK;
    private static int PSDBIT;
    private static int PSDMASK;
    private static int PORTBITVALUE;
    private static int PORTMASKVALUE;
    private static int[][] portInfoMap;

    public void setEntry(byte[] byArray) {
        int n;
        if (RAS.isEnabled(4, 19)) {
            RAS.enter(4, 19, this, "setEntry");
        }
        if ((n = byArray.length) == 19 || n == 35) {
            this.version = V1;
            baseOffset = BASEPORTOFFSETv1;
        } else if (n == 20 || n == 36) {
            this.version = V2;
            baseOffset = BASEPORTOFFSETv2;
        } else {
            if (RAS.isEnabled(4, 19)) {
                RAS.exit(4, 19, this, "setEntry");
            }
            return;
        }
        this.entry = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            this.entry[n2] = byArray[n2];
            ++n2;
        }
        if (RAS.isEnabled(4, 19)) {
            RAS.exit(4, 19, this, "setEntry");
        }
    }

    public void setEntry(OctetString octetString) {
        if (RAS.isEnabled(4, 19)) {
            RAS.enter(4, 19, this, "setEntry");
        }
        if (octetString == null) {
            if (RAS.isEnabled(4, 19)) {
                RAS.exit(4, 19, this, "setEntry");
            }
            return;
        }
        int n = octetString.value.length;
        if (n == 19 || n == 35) {
            this.version = V1;
            baseOffset = BASEPORTOFFSETv1;
        } else if (n == 20 || n == 36) {
            this.version = V2;
            baseOffset = BASEPORTOFFSETv2;
        } else {
            if (RAS.isEnabled(4, 19)) {
                RAS.exit(4, 19, this, "setEntry");
            }
            return;
        }
        this.entry = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            this.entry[n2] = octetString.value[n2];
            ++n2;
        }
        if (RAS.isEnabled(4, 19)) {
            RAS.exit(4, 19, this, "setEntry");
        }
    }

    public int module(int n) {
        if (this.entry == null) {
            return -1;
        }
        if (this.version == V1) {
            byte by = this.entry[hubInfoMapv1[n][HUBBYTEVALUE]];
            byte by2 = (byte)(by >> hubInfoMapv1[n][HUBBITVALUE]);
            return this.entry[hubInfoMapv1[n][HUBBYTEVALUE]] >> hubInfoMapv1[n][HUBBITVALUE] & hubInfoMapv1[n][HUBMASKVALUE];
        }
        if (this.version == V2) {
            byte by = this.entry[hubInfoMapv2[n][HUBBYTEVALUE]];
            byte by3 = (byte)(by >> hubInfoMapv2[n][HUBBITVALUE]);
            return this.entry[hubInfoMapv2[n][HUBBYTEVALUE]] >> hubInfoMapv2[n][HUBBITVALUE] & hubInfoMapv2[n][HUBMASKVALUE];
        }
        return -1;
    }

    public int port(int n, int n2) {
        if (this.entry == null) {
            return -1;
        }
        return this.entry[baseOffset + n] >> portInfoMap[n2][PORTBITVALUE] & portInfoMap[n2][PORTMASKVALUE];
    }

    public int numberOfPorts() {
        if (this.entry == null) {
            return -1;
        }
        if (this.entry.length > 20) {
            return 32;
        }
        return 16;
    }

    public int version() {
        return this.version;
    }

    static {
        HUBTYPE = 1;
        EXPTYPE = 2;
        RIROTYPE = 3;
        RINGSPEED = 4;
        LOADSTATUS = 5;
        FANSTATUS = 6;
        DATAINSTATUS = 7;
        DATAOUTSTATUS = 8;
        RINGINSTATUS = 9;
        RINGOUTSTATUS = 10;
        CONTROLINSTATUS = 11;
        CONTROLOUTSTATUS = 12;
        HUBMAX = 13;
        HIBIT = 4;
        HIMASK = 15;
        HTBIT = 3;
        HTMASK = 1;
        ETBIT = 2;
        ETMASK = 1;
        RTMASK = 3;
        RSBYTE = 1;
        RSBIT = 7;
        RSMASK = 1;
        LSBYTE = 1;
        LSBIT = 6;
        LSMASK = 1;
        FSBYTE = 1;
        FSBIT = 5;
        FSMASK = 1;
        DISBYTEv1 = 2;
        DISBITv1 = 7;
        DISMASKv1 = 1;
        DISBYTEv2 = 2;
        DISBITv2 = 7;
        DISMASKv2 = 3;
        DOSBYTEv1 = 2;
        DOSBITv1 = 6;
        DOSMASKv1 = 1;
        DOSBYTEv2 = 2;
        DOSBITv2 = 6;
        DOSMASKv2 = 3;
        RISBYTEv1 = 2;
        RISBITv1 = 5;
        RISMASKv1 = 1;
        RISBYTEv2 = 2;
        RISBITv2 = 5;
        RISMASKv2 = 3;
        ROSBYTEv1 = 2;
        ROSBITv1 = 4;
        ROSMASKv1 = 1;
        ROSBYTEv2 = 2;
        ROSBITv2 = 4;
        ROSMASKv2 = 3;
        CISBYTEv1 = 2;
        CISBITv1 = 3;
        CISMASKv1 = 1;
        CISBYTEv2 = 2;
        CISBITv2 = 3;
        CISMASKv2 = 3;
        COSBYTEv1 = 2;
        COSBITv1 = 2;
        COSMASKv1 = 1;
        COSBYTEv2 = 2;
        COSBITv2 = 2;
        COSMASKv2 = 3;
        HUBBITVALUE = 1;
        HUBMASKVALUE = 2;
        hubInfoMapv1 = new int[][]{{HIBYTE, HIBIT, HIMASK}, {HTBYTE, HTBIT, HTMASK}, {ETBYTE, ETBIT, ETMASK}, {RTBYTE, RTBIT, RTMASK}, {RSBYTE, RSBIT, RSMASK}, {LSBYTE, LSBIT, LSMASK}, {FSBYTE, FSBIT, FSMASK}, {DISBYTEv1, DISBITv1, DISMASKv1}, {DOSBYTEv1, DOSBITv1, DOSMASKv1}, {RISBYTEv1, RISBITv1, RISMASKv1}, {ROSBYTEv1, ROSBITv1, ROSMASKv1}, {CISBYTEv1, CISBITv1, CISMASKv1}, {COSBYTEv1, COSBITv1, COSMASKv1}};
        hubInfoMapv2 = new int[][]{{HIBYTE, HIBIT, HIMASK}, {HTBYTE, HTBIT, HTMASK}, {ETBYTE, ETBIT, ETMASK}, {RTBYTE, RTBIT, RTMASK}, {RSBYTE, RSBIT, RSMASK}, {LSBYTE, LSBIT, LSMASK}, {FSBYTE, FSBIT, FSMASK}, {DISBYTEv2, DISBITv2, DISMASKv2}, {DOSBYTEv2, DOSBITv2, DOSMASKv2}, {RISBYTEv2, RISBITv2, RISMASKv2}, {ROSBYTEv2, ROSBITv2, ROSMASKv2}, {CISBYTEv2, CISBITv2, CISMASKv2}, {COSBYTEv2, COSBITv2, COSMASKv2}};
        PORTMODE = 1;
        PORTALERT = 2;
        PORTSECURITY = 3;
        PORTSPEED = 4;
        PORTMAX = 5;
        BASEPORTOFFSETv1 = 2;
        BASEPORTOFFSETv2 = 3;
        PSTBIT = 4;
        PSTMASK = 15;
        PMDBIT = 3;
        PMDMASK = 1;
        PATBIT = 2;
        PATMASK = 1;
        PSEBIT = 1;
        PSEMASK = 1;
        PSDMASK = 1;
        PORTMASKVALUE = 1;
        portInfoMap = new int[][]{{PSTBIT, PSTMASK}, {PMDBIT, PMDMASK}, {PATBIT, PATMASK}, {PSEBIT, PSEMASK}, {PSDBIT, PSDMASK}};
    }
}

